/*
 *   MIRACL Comba's method for ultimate speed binary polynomial
 *   mrcomba2.tpl 
 *
 *   Here the inner loops of the basic multiplication, and squaring  
 *   algorithms are completely unravelled, and  reorganised for maximum possible speed. 
 *
 *   This approach is recommended for maximum speed where parameters
 *   are fixed and compute resources are constrained. The processor MUST 
 *   support a special binary polynomial multiplication instruction
 *
 *   This file is a template. To fill in the gaps and create mrcomba2.c, 
 *   you must run the mex.c program to insert the C or assembly language 
 *   macros from the appropriate .mcs file. 
 *
 *   This method would appear to be particularly useful for implementing 
 *   fast Elliptic Curve Cryptosystems over GF(2^m) 
 *
 *   The #define MR_COMBA2 in mirdef.h determines the FIXED size of 
 *   modulus to be used. This *must* be determined at compile time. 
 *
 *   Note that this module can generate a *lot* of code for large values 
 *   of MR_COMBA2. This should have a maximum value of 8-16.
 *
 *   Note that on some processors it is *VITAL* that arrays be aligned on 
 *   4-byte boundaries
 *
 *   Copyright (c) 2006 Shamus Software Ltd.
 */

#include "miracl.h"    

#ifdef MR_COMBA2

/* NOTE! z must be distinct from x and y */

void comba_mult2(_MIPD_ big x,big y,big z) 
{ /* comba multiplier */
    int i;
    mr_small *a,*b,*c;
    big w;

#ifdef MR_OS_THREADS
    miracl *mr_mip=get_mip();
#endif
    w=mr_mip->w0; 
    for (i=2*MR_COMBA2;i<(int)(w->len&MR_OBITS);i++) w->w[i]=0;
    w->len=2*MR_COMBA2;
    a=x->w; b=y->w; c=w->w;
/*** MULTIPLY2 ***/      /* multiply a by b, result in c */
  ASM (
  "ADDU $5,$0,%0\n"
  "ADDU $6,$0,%1\n"
  "ADDU $7,$0,%2\n"
  "MTLHX $0\n"
  "MTLHX $0\n"
  "MTLHX $0\n"
  "LW $2,4*0($5)\n"  
  "LW $3,4*0($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*0($7)\n"
  "LW $2,4*0($5)\n"  
  "LW $3,4*1($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*1($5)\n"  
  "LW $3,4*0($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*1($7)\n"
  "LW $2,4*0($5)\n"  
  "LW $3,4*2($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*1($5)\n"  
  "LW $3,4*1($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*2($5)\n"  
  "LW $3,4*0($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*2($7)\n"
  "LW $2,4*0($5)\n"  
  "LW $3,4*3($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*1($5)\n"  
  "LW $3,4*2($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*2($5)\n"  
  "LW $3,4*1($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*3($5)\n"  
  "LW $3,4*0($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*3($7)\n"
  "LW $2,4*0($5)\n"  
  "LW $3,4*4($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*1($5)\n"  
  "LW $3,4*3($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*2($5)\n"  
  "LW $3,4*2($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*3($5)\n"  
  "LW $3,4*1($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*4($5)\n"  
  "LW $3,4*0($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*4($7)\n"
  "LW $2,4*0($5)\n"  
  "LW $3,4*5($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*1($5)\n"  
  "LW $3,4*4($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*2($5)\n"  
  "LW $3,4*3($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*3($5)\n"  
  "LW $3,4*2($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*4($5)\n"  
  "LW $3,4*1($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*5($5)\n"  
  "LW $3,4*0($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*5($7)\n"
  "LW $2,4*0($5)\n"  
  "LW $3,4*6($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*1($5)\n"  
  "LW $3,4*5($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*2($5)\n"  
  "LW $3,4*4($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*3($5)\n"  
  "LW $3,4*3($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*4($5)\n"  
  "LW $3,4*2($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*5($5)\n"  
  "LW $3,4*1($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*6($5)\n"  
  "LW $3,4*0($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*6($7)\n"
  "LW $2,4*0($5)\n"  
  "LW $3,4*7($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*1($5)\n"  
  "LW $3,4*6($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*2($5)\n"  
  "LW $3,4*5($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*3($5)\n"  
  "LW $3,4*4($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*4($5)\n"  
  "LW $3,4*3($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*5($5)\n"  
  "LW $3,4*2($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*6($5)\n"  
  "LW $3,4*1($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*7($5)\n"  
  "LW $3,4*0($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*7($7)\n"
  "LW $2,4*0($5)\n"  
  "LW $3,4*8($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*1($5)\n"  
  "LW $3,4*7($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*2($5)\n"  
  "LW $3,4*6($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*3($5)\n"  
  "LW $3,4*5($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*4($5)\n"  
  "LW $3,4*4($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*5($5)\n"  
  "LW $3,4*3($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*6($5)\n"  
  "LW $3,4*2($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*7($5)\n"  
  "LW $3,4*1($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*8($5)\n"  
  "LW $3,4*0($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*8($7)\n"
  "LW $2,4*0($5)\n"  
  "LW $3,4*9($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*1($5)\n"  
  "LW $3,4*8($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*2($5)\n"  
  "LW $3,4*7($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*3($5)\n"  
  "LW $3,4*6($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*4($5)\n"  
  "LW $3,4*5($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*5($5)\n"  
  "LW $3,4*4($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*6($5)\n"  
  "LW $3,4*3($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*7($5)\n"  
  "LW $3,4*2($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*8($5)\n"  
  "LW $3,4*1($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*9($5)\n"  
  "LW $3,4*0($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*9($7)\n"
  "LW $2,4*0($5)\n"  
  "LW $3,4*10($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*1($5)\n"  
  "LW $3,4*9($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*2($5)\n"  
  "LW $3,4*8($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*3($5)\n"  
  "LW $3,4*7($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*4($5)\n"  
  "LW $3,4*6($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*5($5)\n"  
  "LW $3,4*5($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*6($5)\n"  
  "LW $3,4*4($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*7($5)\n"  
  "LW $3,4*3($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*8($5)\n"  
  "LW $3,4*2($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*9($5)\n"  
  "LW $3,4*1($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*10($5)\n"  
  "LW $3,4*0($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*10($7)\n"
  "LW $2,4*0($5)\n"  
  "LW $3,4*11($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*1($5)\n"  
  "LW $3,4*10($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*2($5)\n"  
  "LW $3,4*9($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*3($5)\n"  
  "LW $3,4*8($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*4($5)\n"  
  "LW $3,4*7($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*5($5)\n"  
  "LW $3,4*6($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*6($5)\n"  
  "LW $3,4*5($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*7($5)\n"  
  "LW $3,4*4($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*8($5)\n"  
  "LW $3,4*3($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*9($5)\n"  
  "LW $3,4*2($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*10($5)\n"  
  "LW $3,4*1($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*11($5)\n"  
  "LW $3,4*0($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*11($7)\n"
  "LW $2,4*1($5)\n"  
  "LW $3,4*11($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*2($5)\n"  
  "LW $3,4*10($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*3($5)\n"  
  "LW $3,4*9($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*4($5)\n"  
  "LW $3,4*8($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*5($5)\n"  
  "LW $3,4*7($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*6($5)\n"  
  "LW $3,4*6($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*7($5)\n"  
  "LW $3,4*5($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*8($5)\n"  
  "LW $3,4*4($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*9($5)\n"  
  "LW $3,4*3($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*10($5)\n"  
  "LW $3,4*2($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*11($5)\n"  
  "LW $3,4*1($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*12($7)\n"
  "LW $2,4*2($5)\n"  
  "LW $3,4*11($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*3($5)\n"  
  "LW $3,4*10($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*4($5)\n"  
  "LW $3,4*9($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*5($5)\n"  
  "LW $3,4*8($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*6($5)\n"  
  "LW $3,4*7($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*7($5)\n"  
  "LW $3,4*6($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*8($5)\n"  
  "LW $3,4*5($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*9($5)\n"  
  "LW $3,4*4($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*10($5)\n"  
  "LW $3,4*3($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*11($5)\n"  
  "LW $3,4*2($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*13($7)\n"
  "LW $2,4*3($5)\n"  
  "LW $3,4*11($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*4($5)\n"  
  "LW $3,4*10($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*5($5)\n"  
  "LW $3,4*9($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*6($5)\n"  
  "LW $3,4*8($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*7($5)\n"  
  "LW $3,4*7($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*8($5)\n"  
  "LW $3,4*6($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*9($5)\n"  
  "LW $3,4*5($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*10($5)\n"  
  "LW $3,4*4($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*11($5)\n"  
  "LW $3,4*3($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*14($7)\n"
  "LW $2,4*4($5)\n"  
  "LW $3,4*11($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*5($5)\n"  
  "LW $3,4*10($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*6($5)\n"  
  "LW $3,4*9($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*7($5)\n"  
  "LW $3,4*8($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*8($5)\n"  
  "LW $3,4*7($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*9($5)\n"  
  "LW $3,4*6($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*10($5)\n"  
  "LW $3,4*5($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*11($5)\n"  
  "LW $3,4*4($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*15($7)\n"
  "LW $2,4*5($5)\n"  
  "LW $3,4*11($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*6($5)\n"  
  "LW $3,4*10($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*7($5)\n"  
  "LW $3,4*9($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*8($5)\n"  
  "LW $3,4*8($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*9($5)\n"  
  "LW $3,4*7($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*10($5)\n"  
  "LW $3,4*6($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*11($5)\n"  
  "LW $3,4*5($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*16($7)\n"
  "LW $2,4*6($5)\n"  
  "LW $3,4*11($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*7($5)\n"  
  "LW $3,4*10($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*8($5)\n"  
  "LW $3,4*9($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*9($5)\n"  
  "LW $3,4*8($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*10($5)\n"  
  "LW $3,4*7($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*11($5)\n"  
  "LW $3,4*6($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*17($7)\n"
  "LW $2,4*7($5)\n"  
  "LW $3,4*11($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*8($5)\n"  
  "LW $3,4*10($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*9($5)\n"  
  "LW $3,4*9($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*10($5)\n"  
  "LW $3,4*8($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*11($5)\n"  
  "LW $3,4*7($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*18($7)\n"
  "LW $2,4*8($5)\n"  
  "LW $3,4*11($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*9($5)\n"  
  "LW $3,4*10($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*10($5)\n"  
  "LW $3,4*9($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*11($5)\n"  
  "LW $3,4*8($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*19($7)\n"
  "LW $2,4*9($5)\n"  
  "LW $3,4*11($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*10($5)\n"  
  "LW $3,4*10($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*11($5)\n"  
  "LW $3,4*9($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*20($7)\n"
  "LW $2,4*10($5)\n"  
  "LW $3,4*11($6)\n"
  "MADDP $2,$3\n"
  "LW $2,4*11($5)\n"  
  "LW $3,4*10($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*21($7)\n"
  "LW $2,4*11($5)\n"  
  "LW $3,4*11($6)\n"
  "MADDP $2,$3\n"
  "MFLHXU $2\n"
  "SW $2,4*22($7)\n"
  "MFLHXU $2\n"
  "SW $2,4*23($7)\n"
  :
  :"r"(a),"r"(b),"r"(c)
  :"$2","$3","$4","$5","$6","$7","$8","$9","memory" 
  );
	
    mr_lzero(w);
    if (w!=z) copy (w,z); 
}   
 
#endif
