		/***********************************/
		/* eeschema.cpp - module principal */
		/***********************************/

#ifdef __GNUG__
#pragma implementation
#endif

#define eda_global
#define MAIN

#include "fctsys.h"

#include <wx/image.h>

#include "common.h"
#include "program.h"
#include "libcmp.h"
#include "general.h"
#include "netlist.h"
#include "worksheet.h"
#include "trigo.h"

#include "protos.h"

#include "bitmaps.h"

/* Routines locales */
static void CreateScreens(void);

// Global variables
wxString Main_Title( wxT("EESchema (15-jan-2006)") );

	/************************************/
	/* Called to initialize the program */
	/************************************/

// Create a new application object: this macro will allow wxWindows to create
// the application object during program execution (it's better than using a
// static object for many reasons) and also declares the accessor function
// wxGetApp() which will return the reference of the right type (i.e. MyApp and
// not wxApp)
IMPLEMENT_APP(WinEDA_App)

bool WinEDA_App::OnInit(void)
{
wxString FFileName;
	EDA_Appl = this;

	g_DebugLevel = 0;	// Debug level */

	InitEDA_Appl( wxT("eeschema") );

    if ( m_Checker && m_Checker->IsAnotherRunning() )
    {
        if ( ! IsOK(NULL, _("Eeschema is already running, Continue?") ) )
			return false;
    }

	if(argc > 1 ) FFileName = argv[1];

	CreateScreens();

	/* init EESCHEMA */
	GetSettings();			// read current setup
	SeedLayers();

	// Create main frame (schematic frame) :
	SchematicFrame = new WinEDA_SchematicFrame(NULL, this,
					 wxT("EESchema"), wxPoint(0,0), wxSize(600,400) );
	ScreenSch->SetParentFrame(SchematicFrame);
	SchematicFrame->Show(TRUE);
	SetTopWindow(SchematicFrame);

	SchematicFrame->Zoom_Automatique(TRUE);

	/* Load file specified in the command line. */
	if( ! FFileName.IsEmpty() )
	{
		ChangeFileNameExt(FFileName, g_SchExtBuffer);
		wxSetWorkingDirectory( wxPathOnly(FFileName) );
		if ( SchematicFrame->LoadOneEEProject(FFileName, FALSE) <= 0 )
			SchematicFrame->DrawPanel->Refresh(TRUE);	// File not found or error
	}

	else
	{
		Read_Config(wxEmptyString, TRUE); // Read config file ici si pas de fichier a charger
		SchematicFrame->DrawPanel->Refresh(TRUE);
	}

	return TRUE;
}


/******************************/
static void CreateScreens(void)
/******************************/
/*
 Fonction d'init des crans utiliss dans EESchema:
*/
{
	/* creation des ecrans Sch , Lib et ViewPart */

	if(ScreenSch == NULL )
		ScreenSch = new SCH_SCREEN(NULL, NULL, SCHEMATIC_FRAME);
	ScreenSch->m_FileName = g_DefaultSchematicFileName;
	ScreenSch->m_Date = GenDate();
	ActiveScreen = ScreenSch;

	if(ScreenLib == NULL )
		ScreenLib = new SCH_SCREEN(NULL, NULL, LIBEDITOR_FRAME);
	ScreenLib->SetZoom(16);
	ScreenLib->m_UndoRedoCountMax = 10;
}

