!!ARBvp1.0

# special shader used for generating mirror images with clipping, just does simple diffuse lighting + texmap
#textures:
#texture[0], 2D		- (diffuse) color map, RGB

ATTRIB inputpos = vertex.position;		# object space
ATTRIB normal = vertex.normal; 			# object space
ATTRIB texcoordmodel = vertex.texcoord[0];

PARAM mvp[4] = { state.matrix.mvp };
PARAM mvinv[4] = { state.matrix.modelview.inverse };
PARAM lightpos = state.light[0].position;	# world space
PARAM	lightcolor = state.light[0].diffuse;
PARAM	lightambient = state.light[0].ambient;

PARAM texmatdiff[4] = { state.matrix.texture[0] };
PARAM cliptrans[4] = { state.matrix.texture[1] };

# fog needed for that shader.

# fixme: diffuse lighting computation seems sometimes to be wrong.
# clamping is missing
# colors appear to bright (light source direction wrong?)

OUTPUT outputpos = result.position;		# world space
OUTPUT outtexcoorddiff = result.texcoord[0];
OUTPUT lightdiffusecol = result.color;

TEMP tmp;
TEMP lightdir;
TEMP clipscal;

# 1. compute direction to light
# 1.1. transform light pos to object space. we assume mvinv has no projection coefficients.
DP4	tmp.x, mvinv[0], lightpos;
DP4	tmp.y, mvinv[1], lightpos;
DP4	tmp.z, mvinv[2], lightpos;

# 1.2. compute direction in object space (independent if directional light or not!)
# if (lightpos.w == 0) lp = lightpos; else lp = lightpos - inputpos;
# if w is only 0 or 1, use  lp = lightpos - w * inputpos;
MAD	tmp, -lightpos.w, inputpos, tmp;

# 1.3. normalize it
DP3	tmp.w, tmp, tmp;
RSQ	tmp.w, tmp.w;
MUL	lightdir.xyz, tmp.w, tmp;

# 1.4. compute diffuse lighting coefficient (fixme: ambient?!)
DP3	tmp, lightdir, normal;
# clamp at zero
MAX	tmp.x, tmp.x, 0;
MUL	lightdiffusecol, tmp, lightcolor;


# 2. compute texture coordinates. (z/w components are not used)
# 2.1. for map 1
DP4	outtexcoorddiff.x, texmatdiff[0], texcoordmodel;
DP4	outtexcoorddiff.y, texmatdiff[1], texcoordmodel;


# 3. transform vertex to projection space (clip coordinates)
# transform to clip space (only transform x/y/z as w is one and clip3 is 0,0,0,1)
DP4	tmp.x, cliptrans[0], inputpos;
DP4	tmp.y, cliptrans[1], inputpos;
DP4	tmp.z, cliptrans[2], inputpos;
DP4	tmp.w, cliptrans[3], inputpos;
# clip
SGE	clipscal.x, tmp.z, 0;
MUL	tmp.z, tmp.z, clipscal.x;
# transform to output space (eye/clip space)
DP4	outputpos.x, mvp[0], tmp;
DP4	outputpos.y, mvp[1], tmp;
DP4	outputpos.z, mvp[2], tmp;
DP4	outputpos.w, mvp[3], tmp;

END
