!!ARBfp1.0

#textures:
#texture[0], 2D		- (diffuse) color map, RGB
#texture[1], 2D		- normal map, RGB
#texture[2], 2D		- (if existent) specular map, LUMINANCE

# fixme: maybe a normalization cube map is faster than RSQ

# fixme: fog? fog must be done by fragment program!!! program code depends on the fog type!

ATTRIB	texcoorddiff = fragment.texcoord[0];	# texcoords for map 1
ATTRIB	texcoordnrml = fragment.texcoord[1];	# texcoords for map 2
ATTRIB	lightdir = fragment.texcoord[2]; 	# vector to light source (sun)
ATTRIB	halfangle = fragment.texcoord[3];	# half angle vector between lightdir and viewerdir

PARAM	lightcolor = state.light[0].diffuse;
PARAM	lightambient = state.light[0].ambient;
#PARAM	matdiffuse = state.material.diffuse;
PARAM	matspecular = state.material.specular;
PARAM	matshininess = state.material.shininess;


OUTPUT	outputcolor = result.color;			# fragment color output

TEMP	L;		# direction to light (normalized)
TEMP	H;		# halfangle (normalized)
TEMP	N;		# normal, from normal map (normalized)
TEMP	diffcol;
TEMP	speccol;
TEMP	tmp;


# 1. get and normalize vector to light source
DP3	L.w, lightdir, lightdir;
RSQ	L.w, L.w;
MUL	L.xyz, L.w, lightdir;


# 2. get and normalize normal vector from texmap
TEX	N, texcoordnrml, texture[1], 2D;	# get
MAD	N, N, 2, -1;				# expand
DP3	N.w, N, N;				# normalize
RSQ	N.w, N.w;
MUL	N.xyz, N.w, N;

#when not doing normal mapping:
# retrieve normal vector from texcoord 0 ? we need per pixel normals for spec mapping and texcoords for diff mapping.
# so replace lightdir by normal and give diff color/brightness as fragment color?
#MOV	normalv, ???;


# 3. compute diffuse color
# 3.1. base brightness from L.N
TEX	diffcol, texcoorddiff, texture[0], 2D;
DP3_SAT	tmp, N, L;

# 3.2. add ambient (fixme, better use LRP between brightness and 1 with ambient as scale)
# LRP tmp, lightambient.y, 1, tmp;
#ADD_SAT	tmp, tmp, lightambient;
LRP	tmp, lightambient, 1, tmp;
MUL	diffcol, diffcol, tmp;

#MOV	diffcol, tmp;
#MOV	diffcol, L;
#ambient error: caused by weird L !


# 4. compute specular color
# 4.1. get and normalize half angle vector
DP3	H.w, halfangle, halfangle;
RSQ	H.w, H.w;
MUL	H.xyz, H.w, halfangle;

# 4.2. compute specular light brightness (blinn-phong shading)
# spec = (H.N)^shininess
DP3_SAT	tmp, H, N;
POW	tmp.x, tmp.x, matshininess.x;	# fixme: could be read from a 1D map if that is faster
# this pow eats 6-7 percent of performance when rendering full screen faces with this shader
# a TEX-instruction could be faster
MUL	speccol, matspecular, tmp.x;

# 4.3. scale that with specular map
#ifdef USE_SPECULARMAP
TEX	tmp, texcoordnrml, texture[2], 2D;
MUL	speccol, speccol, tmp;
#endif


# 5. sum colors (diffuse + specular), multiply with light color and write that
ADD	tmp, diffcol, speccol;
MUL	outputcolor.xyz, tmp, lightcolor;
MOV	outputcolor.w, 1; # fixme, get rid of this extra instruction

END
